A = importdata('before_OM1.txt', ',',48);
A_m90 = importdata('before_OM1_ZM2_Y_minus90.txt', ',',48);
A_m250 = importdata('before_OM1_ZM2_Y_minus250.txt', ',',48);
A_m350 = importdata('before_OM1_ZM2_Y_minus350.txt', ',',48);
A_m450 = importdata('before_OM1_ZM2_Y_minus450.txt', ',',48);
A_m550 = importdata('before_OM1_ZM2_Y_minus550.txt', ',',48);
afterZM1 = importdata('29_and_3_quarters_from_ZM1.txt', ',',48);
ifo_beam = importdata('initial_ifo_beam.txt', ',', 48);

meas=[A, A_m90, A_m250, A_m350, A_m450, A_m550];

%find the location of the maximum intesity for both horizontal and vertical
%profiles
for ii=1:length(meas)
    this_meas=meas(ii);
    [vert_max(ii),vert_max_loc(ii)]=max(this_meas.data(:,2));
    [horiz_max(ii),horiz_max_loc(ii)]=max(this_meas.data(:,4));
end

%plot the profiles with the positions shifted so max is at zero
figure(1)
subplot(2,1,1)
for ii=1:length(meas)
    this_meas=meas(ii);
    plot(this_meas.data(:,1)-this_meas.data(vert_max_loc(ii),1),this_meas.data(:,2)./vert_max(ii))
    hold on
end
hold off
legend('original position of ZM2 yaw',...
    'ZM2 yaw -90 (counts)',...
    'ZM2 yaw -250',...
    '-350',...
    '-450',...
    '-550')
grid on
xlim([-1500, 1500])
ylim([0,Inf])
xlabel('Vertical position [um]')
ylabel(['Normalized intensity'])

subplot(2,1,2)
for ii=1:length(meas)
    this_meas=meas(ii);
    plot(this_meas.data(:,3)-this_meas.data(horiz_max_loc(ii),3),this_meas.data(:,4)./horiz_max(ii))
    hold on
end
hold off
legend('original position of ZM2 yaw',...
    'ZM2 yaw -90 (counts)',...
    'ZM2 yaw -250',...
    '-350',...
    '-450',...
    '-550')
grid on
ylim([0,Inf])
xlim([-1500, 1500])
xlabel('Horizontal position [um]')
ylabel(['Normalized intensity'])

print(gcf, 'Seed_b4_OM1.png', '-dpng')

[ifo_max_1, ifo_max_1_loc]=max(ifo_beam.data(:,2));
[ifo_max_2, ifo_max_2_loc]=max(ifo_beam.data(:,4));
[zm1_max_1, zm1_max_1_loc]=max(afterZM1.data(:,2));
[zm1_max_2, zm1_max_2_loc]=max(afterZM1.data(:,4));

%do some guausian fitting
%gausian=@(Itot,w,x0,offset,x)Itot.*exp(-(x-x0).^2/(2*w^2))-offset;

%matlab fitting can't handle NaN, nano scan puts Nans in when the size of
%the ROIs aren't the same, need to delete them
ifo_beam_a2=ifo_beam.data(:,3:4);
nan_start_index=find(isnan(ifo_beam_a2(:,1)),1); %find index of first nan element
ifo_beam_a2(nan_start_index:end,:)=[];

afterZM1_a1=afterZM1.data(:,1:2);
nan_start_index=find(isnan(afterZM1_a1(:,1)),1); %find index of first nan element
afterZM1_a1(nan_start_index:end,:)=[];

ifo_a1_fit=fit(ifo_beam.data(:,1),  ifo_beam.data(:,2),...
    'gauss1','Normalize','on','Robust','Bisquare');
ifo_a2_fit=fit(ifo_beam_a2(:,1),  ifo_beam_a2(:,2),...
    'gauss1','Normalize','on','Robust','Bisquare');
zm1_a1_fit=fit(afterZM1_a1(:,1),  afterZM1_a1(:,2),...
    'gauss1','Normalize','on','Robust','Bisquare');
zm1_a2_fit=fit(afterZM1.data(:,3),  afterZM1.data(:,4),...
    'gauss1','Normalize','on','Robust','Bisquare');

figure(2)
subplot(2,1,1)
plot(ifo_a1_fit,...
    ifo_beam.data(:,1), ifo_beam.data(:,2))
legend('data')
grid on
ylim([0,Inf])

subplot(2,1,2)
plot(ifo_a2_fit,...
    ifo_beam_a2(:,1), ifo_beam_a2(:,2))
legend('fit', 'data')
grid on
ylim([0,Inf])
ylabel(['Normalized intensity'])
%print(gcf, 'single_bounce_ifo.png', '-dpng')

figure(4)
plot(ifo_beam.data(:,1)-ifo_beam.data(ifo_max_1_loc,1), ifo_beam.data(:,2)./ifo_max_1,...
    ifo_beam.data(:,3)-ifo_beam.data(ifo_max_2_loc,3), ifo_beam.data(:,4)./ifo_max_2)
legend('Aperture 1', 'Aperture 2')
grid on
ylim([0,Inf])
xlabel('Position [um]')
ylabel(['Normalized intensity'])
print(gcf, 'single_bounce_ifo.png', '-dpng')

figure(3)
plot(afterZM1.data(:,1)-afterZM1.data(zm1_max_1_loc,1), afterZM1.data(:,2)./zm1_max_1,...
    afterZM1.data(:,3)-afterZM1.data(zm1_max_2_loc,3), afterZM1.data(:,4)./zm1_max_2)
legend('Aperture 1', 'Aperture 2')
grid on
ylim([0,Inf])
xlabel('Position [um]')
ylabel(['Normalized intensity'])
print(gcf, 'beam_from_VIP.png', '-dpng')

figure(5)
subplot(2,1,1)
plot(zm1_a1_fit,...
    afterZM1.data(:,1), afterZM1.data(:,2))
legend('data')
grid on
ylim([0,Inf])

subplot(2,1,2)
plot(zm1_a2_fit,...
    afterZM1.data(:,3), afterZM1.data(:,4))
legend('fit', 'data')
grid on
ylim([0,Inf])

astigmatism_after_zm1=zm1_a1_fit.c1/zm1_a2_fit.c1